import React from "react";
import { View, Text, TouchableOpacity, FlatList } from "react-native";
import BackNavigation from "../../../../../Utilities/CustomHeader/BackNavigation";
import CommonStyles from "../../../../../Utilities/CommonStyles/CommonStyles";
import dpr from "../../../../../Utilities/CustomStyleAttribute/dpr";
import { reviewStyle } from "./reviewStyle";
import SignatureIcon from "../../../../../../assets/svgs/product details/signature 1.svg";
import usePreferences from "../../../../../../hooks/usePreferences";
import CustomRating from "../../../../../Utilities/CustomRating/CustomRating";
import SingleReview from "./SingleReview";
import CustomActiveIndicator from "../../../../../../src/components/CustomLoader/CustomActiveIndicator";
import SingleReviewImages from "./SingleReviewImages";
import useLangTranslation from "../../../../../../hooks/useLangTranslation";
import { useState } from "react";
import { queryResponse } from "../../../../../../redux/slices/util/processResponse";
import CustomSVG from "../../../../../../src/components/CustomSVG/CustomSVG";

const Reviews = (props) => {
    const { reviewImages, avgRating, productDetails, setProductDetails, Reviews: review,
        nextPageUrl: pageUrl, setReviews } =
        props.route.params;
    const { id, can_review } = productDetails || {};
    const { trans } = useLangTranslation();

    const [moreReviews, setMoreReviews] = useState(review);
    const [loadMore, setLoadMore] = useState(false);
    const [nextPageUrl, setNextPageUrl] = useState(pageUrl);
    const { product_general: { rating_enable } = {} } = usePreferences();

    const [canReview, setCanReview] = useState(can_review);

    const handleLoadMoreReviews = async () => {
        let isMounted = true;
        if (isMounted && nextPageUrl && !loadMore) {
            try {
                setLoadMore(true)
                const res = await queryResponse(nextPageUrl, 'GET');
                const { records, status: { code } = {} } = res || {};
                const { data, pagination } = records || {};
                if (code == 200) {
                    setMoreReviews([...moreReviews, ...data]);
                    setNextPageUrl(pagination?.next_page_url)
                } else {
                    setMoreReviews(moreReviews);
                }
            } catch (error) {} finally {
                setLoadMore(false)
            }
        }
        return () => {
            isMounted = false;
        };
    };

    const progressValue = 100;
    const reviews = moreReviews?.map((review) => {
        return {
            rating: Number(review.rating),
            value: progressValue / moreReviews.length,
        };
    });

    const updatedReviews = [
        {
            rating: 5,
            value: 0,
        },
        {
            rating: 4,
            value: 0,
        },
        {
            rating: 3,
            value: 0,
        },
        {
            rating: 2,
            value: 0,
        },
        {
            rating: 1,
            value: 0,
        },
    ];

    for (let i = 0; i < reviews.length; i++) {
        const el = reviews[i];
        const checkIndex = updatedReviews.findIndex(
            (review) => review.rating === el.rating
        );
        if (checkIndex !== -1) {
            updatedReviews[checkIndex].value += el.value;
        }
    }

    return (
        <>
            <BackNavigation
                navigationProps={props.navigation}
                routeName={trans("reviews")}
                capitalize={true}
            />
            <View style={CommonStyles.cont}>
                <FlatList
                    listKey={(_, i) => "r" + i.toString()}
                    ListHeaderComponent={() => (
                        <>
                            {moreReviews?.length > 0 ? (
                                <View style={CommonStyles.globalContainer}>
                                    {rating_enable == 1 && (
                                        <>
                                            <View style={reviewStyle.titleCont}>
                                                <Text
                                                    style={
                                                        reviewStyle.reviewCount
                                                    }
                                                >
                                                    {avgRating.toFixed(1)}
                                                </Text>
                                                <CustomRating
                                                    rating={avgRating}
                                                    starSize={dpr(27)}
                                                    readOnly={true}
                                                />
                                                <Text
                                                    style={
                                                        reviewStyle.reviewAverage
                                                    }
                                                >
                                                    {trans("Average of {{x}} reviews",{ x: moreReviews?.length })}
                                                </Text>
                                            </View>
                                            <View
                                                style={
                                                    reviewStyle.reviewBarCont
                                                }
                                            >
                                                {updatedReviews.map(
                                                    (item, index) => (
                                                        <View
                                                            key={`key${index}`}
                                                            style={
                                                                reviewStyle.reviewProgressCont
                                                            }
                                                        >
                                                            <Text
                                                                style={
                                                                    reviewStyle.ratingText
                                                                }
                                                            >
                                                                {item.rating.toFixed(
                                                                    1
                                                                )}
                                                            </Text>
                                                            <ProgressBar
                                                                progress={
                                                                    item.value
                                                                }
                                                            />
                                                        </View>
                                                    )
                                                )}
                                            </View>
                                        </>
                                    )}
                                    {reviewImages?.length > 0 && (
                                        <>
                                            <View style={reviewStyle.CGCont}>
                                                <Text
                                                    style={reviewStyle.CGText}
                                                >
                                                    {trans("Customers Gallery")}
                                                </Text>
                                                <Text
                                                    style={reviewStyle.CGText}
                                                >
                                                    ({reviewImages?.length})
                                                </Text>
                                            </View>
                                            <SingleReviewImages
                                                images={reviewImages}
                                            />
                                        </>
                                    )}
                                    <>
                                        <View style={reviewStyle.CGCont}>
                                            <Text style={reviewStyle.CGText}>
                                                {trans("Feedbacks")}
                                            </Text>
                                            <Text style={reviewStyle.CGText}>
                                                ({moreReviews?.length})
                                            </Text>
                                        </View>
                                        <View style={reviewStyle.singleReviewWrap}>
                                            {moreReviews.map((item, index) => (
                                                <SingleReview
                                                    key={index}
                                                    item={item}
                                                    index={index}
                                                    Reviews={moreReviews}
                                                />
                                            ))}
                                        </View>
                                    </>
                                </View>
                            ) : (
                                <View>
                                    <Text>{trans("Loading")}</Text>
                                </View>
                            )}
                        </>
                    )}
                    initialNumToRender={10}
                    windowSize={10}
                    onEndReachedThreshold={1}
                    onEndReached={handleLoadMoreReviews}
                />
            </View>
            {loadMore && <CustomActiveIndicator />}
            {canReview && (
                <View style={reviewStyle.writeReviewCont}>
                    <TouchableOpacity
                        disabled={!canReview}
                        style={reviewStyle.writeReview}
                        onPress={() =>
                            props.navigation.navigate("Write a Review", {
                                reviews: moreReviews,
                                productDetails: productDetails,
                                setProductDetails: setProductDetails,
                                setCanReview: setCanReview,
                                avgRating: avgRating,
                                setMoreReviews,
                                setNextPageUrl,
                                setReviews
                            })
                        }
                    >
                        <CustomSVG svgIcon={SignatureIcon} height={dpr(24)} width={dpr(24)} />
                        <Text style={reviewStyle.writeText}>
                            {trans("Write a Review")}
                        </Text>
                    </TouchableOpacity>
                </View>
            )}
        </>
    );
};

export default Reviews;

const ProgressBar = ({ progress }) => {
    return (
        <View style={reviewStyle.progressBar}>
            <View style={reviewStyle.progress(progress)} />
        </View>
    );
};
